{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 07.01.99 - 11:17:39 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  MMObj,
  MMDSPObj,
  MMWave,
  MMCstDlg,
  MMSystem,
  MMPCMSup,
  StdCtrls, MMGauge;

type
  TForm1 = class(TForm)
    Button1: TButton;
    OpenDialog: TMMWaveOpenDialog;
    WaveFile: TMMWaveFile;
    Gauge1: TMMGauge;
    procedure Button1Click(Sender: TObject);
  private
    procedure CvtProgressCB(Sender: TObject; CurByte, NumBytes: Longint;
                            Var Cancel: Boolean);

  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.Button1Click(Sender: TObject);
var
   wfx: TWaveFormatEx;
begin
   if OpenDialog.Execute then
   begin
      WaveFile.Wave.FileName := OpenDialog.FileName;
      if WaveFile.Wave.FormatTag = WAVE_FORMAT_PCM then
      begin
         { build the destination header... }
         with WaveFile.Wave.PWaveFormat^ do
         pcmBuildWaveHeader(@wfx,wBitsPerSample,nChannels,44100);

         WaveFile.Wave.EndPos := WaveFile.Wave.DataSize-1;
         
         { convert the file... }
         WaveFile.Wave.OnProgress := CvtProgressCB;
         WaveFile.Wave.ConvertFile('C:\Test.wav',@wfx);

         Gauge1.Progress := 0;
      end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.CvtProgressCB(Sender: TObject; CurByte, NumBytes: Longint;
                        Var Cancel: Boolean);
begin
   Gauge1.Progress := Round((CurByte * 100.0) / NumBytes+0.5);
   Gauge1.Update;
end;

end.
